unit ufind;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms;

type
  // search record
  TFindRec = record
    Text,              // textual format
    Data: string;      // real data to find
    IgnoreCase,        // ignore upper/lower case
    FindText: Boolean; // find text or hex data
  end;

  TdlgFind = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    edFind: TEdit;
    cbText: TCheckBox;
    cbNoCase: TCheckBox;
    procedure edFindChange(Sender: TObject);
  end;

var
  dlgFind: TdlgFind;

// create a find dialog and get options
function FindGetOptions(var Options: TFindRec): Boolean;

implementation

{$R *.DFM}

// determine if a text contains only hex chars and ' '
function IsHex(const Str: string): Boolean;
var
  LIntLoop: Integer;
begin
  Result := Trim(Str) <> '';
  if Result
  then
    for LIntLoop := 1 to Length(Str)
    do
      if not (Str[LIntLoop] in ['0'..'9',' ','a'..'f','A'..'F']) then
      begin
        Result := False;
        Break;
      end;
end;

// create a find dialog and get options
function FindGetOptions(var Options: TFindRec): Boolean;
begin
  with TdlgFind.Create(Application) do
  try
    edFind.Text := Options.Text;

    // if no previous search, gray "find text" to auto determine text/hex
    if Options.Text <> ''
    then
      cbText.Checked := Options.FindText;

    cbNoCase.Checked := Options.IgnoreCase;
    Result := ShowModal = mrOK;
    if Result
    then
      with Options do
      begin
        Text := edFind.Text;
        FindText := cbText.Checked;

        // eventually find out whether text or hex values (0..9,a..f,' ') are entered
        if cbText.State = cbGrayed
        then
          FindText := not IsHex(edFind.Text);

        Data := Text;

        IgnoreCase := cbNoCase.Checked;
      end;

  finally
    Free;
  end;
end;

procedure TdlgFind.edFindChange(Sender: TObject);
begin
  Button1.Enabled := edFind.Text <> '';
end;

end.
